/**
 * Enables the button to mark/unmark best answers.
 *
 * @author  Joshua Ruesweg
 * @copyright  2001-2019 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Thread/BestAnswer
 * @since       5.2
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Core", "WoltLabSuite/Core/Dom/Change/Listener", "WoltLabSuite/Core/Language", "WoltLabSuite/Core/Ui/Confirmation"], function (require, exports, tslib_1, Ajax, Core, DomChangeListener, Language, UiConfirmation) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.init = void 0;
    Ajax = tslib_1.__importStar(Ajax);
    Core = tslib_1.__importStar(Core);
    DomChangeListener = tslib_1.__importStar(DomChangeListener);
    Language = tslib_1.__importStar(Language);
    UiConfirmation = tslib_1.__importStar(UiConfirmation);
    class UiThreadBestAnswer {
        constructor(threadId, containerSelector) {
            this.knownButtons = new WeakSet();
            this.threadId = threadId;
            this.container = document.querySelector(containerSelector || ".wbbThreadPostList");
            this.initButtons();
            DomChangeListener.add(`WoltLabSuite/Forum/Ui/Thread/BestAnswer-${this.threadId}`, () => this.initButtons());
        }
        initButtons() {
            this.container.querySelectorAll(".jsMarkAsBestAnswer").forEach((button) => {
                if (this.knownButtons.has(button)) {
                    return;
                }
                button.addEventListener("click", (event) => this.click(event, button));
                this.knownButtons.add(button);
            });
        }
        click(event, button) {
            event.preventDefault();
            const objectId = ~~button.dataset.objectId;
            if (Core.stringToBool(button.dataset.isBestAnswer)) {
                this.unmarkBestAnswer(objectId);
            }
            else {
                UiConfirmation.show({
                    confirm: () => this.markBestAnswer(objectId),
                    message: Language.get("wbb.thread.markAsBestAnswer.confirmMessage"),
                });
            }
        }
        markBestAnswer(postId) {
            Ajax.api(this, {
                actionName: "markAsBestAnswer",
                parameters: {
                    postID: postId,
                },
            });
        }
        unmarkBestAnswer(postId) {
            Ajax.api(this, {
                actionName: "unmarkAsBestAnswer",
                parameters: {
                    postID: postId,
                },
            });
        }
        _ajaxSuccess() {
            window.location.reload();
        }
        _ajaxSetup() {
            return {
                data: {
                    className: "wbb\\data\\thread\\ThreadAction",
                    parameters: {
                        threadID: this.threadId,
                    },
                },
            };
        }
    }
    let uiThreadBestAnswer;
    function init(threadId, containerSelector) {
        if (!uiThreadBestAnswer) {
            uiThreadBestAnswer = new UiThreadBestAnswer(threadId, containerSelector);
        }
    }
    exports.init = init;
});
