<?php

namespace wbb\system\bulk\processing\thread;

use wbb\data\thread\ThreadAction;
use wbb\data\thread\ThreadList;
use wcf\data\DatabaseObjectList;
use wcf\system\bulk\processing\TReasonedBulkProcessingAction;
use wcf\system\exception\InvalidObjectArgument;

/**
 * Bulk processing action implementation for trashing threads.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Bulk\Processing\Thread
 * @since   5.0
 */
class TrashThreadBulkProcessingAction extends AbstractThreadBulkProcessingAction
{
    use TReasonedBulkProcessingAction;

    /**
     * @inheritDoc
     */
    public function executeAction(DatabaseObjectList $objectList)
    {
        if (!($objectList instanceof ThreadList)) {
            throw new InvalidObjectArgument($objectList, ThreadList::class, 'Object list');
        }

        if (\count($objectList)) {
            /** @noinspection PhpUndefinedFieldInspection */
            $threadAction = new ThreadAction($objectList->getObjects(), $this->object->action, [
                'data' => [
                    'reason' => $this->reason,
                ],
                'isBulkProcessing' => true,
            ]);
            $threadAction->executeAction();
        }
    }

    /**
     * @inheritDoc
     */
    protected function getReasonFieldName()
    {
        return 'threadTrashReason';
    }
}
