<?php

namespace wbb\system\user\notification\event;

use wbb\system\board\status\BoardStatusHandler;
use wbb\system\user\notification\object\ThreadUserNotificationObject;
use wcf\system\user\notification\event\AbstractUserNotificationEvent;
use wcf\system\user\notification\event\ITestableUserNotificationEvent;
use wcf\system\user\storage\UserStorageHandler;
use wcf\system\WCF;

/**
 * Notification event implementation for threads.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\User\Notification\Event
 *
 * @method  ThreadUserNotificationObject    getUserNotificationObject()
 */
class ThreadUserNotificationEvent extends AbstractUserNotificationEvent implements ITestableUserNotificationEvent
{
    use TTestableThreadUserNotificationEvent;

    /**
     * @inheritDoc
     */
    public function getTitle()
    {
        return $this->getLanguage()->get('wbb.thread.notification.title');
    }

    /**
     * @inheritDoc
     */
    public function getMessage()
    {
        return $this->getLanguage()->getDynamicVariable('wbb.thread.notification.message', [
            'userNotificationObject' => $this->getUserNotificationObject(),
            'author' => $this->author,
        ]);
    }

    /**
     * @inheritDoc
     */
    public function getEmailMessage($notificationType = 'instant')
    {
        return [
            'message-id' => 'com.woltlab.wbb.thread/' . $this->getUserNotificationObject()->threadID,
            'template' => 'email_notification_thread',
            'application' => 'wbb',
            'variables' => [
                'thread' => $this->getUserNotificationObject(),
                'author' => $this->author,
            ],
        ];
    }

    /**
     * @inheritDoc
     * @since   5.2
     */
    public function getEmailTitle()
    {
        return $this->getLanguage()->getDynamicVariable('wbb.thread.notification.mail.title', [
            'boardTitle' => $this->getLanguage()->get($this->getUserNotificationObject()->getBoard()->title),
        ]);
    }

    /**
     * @inheritDoc
     */
    public function getLink()
    {
        return $this->getUserNotificationObject()->getURL();
    }

    /**
     * @inheritDoc
     */
    public function checkAccess()
    {
        $returnValue = $this->getUserNotificationObject()->canRead();
        if (!$this->getUserNotificationObject()->getBoard()->canEnter()) {
            // remove subscription
            BoardStatusHandler::getInstance()->saveSubscriptionStatus(
                [$this->getUserNotificationObject()->boardID],
                BoardStatusHandler::SUBSCRIPTION_MODE_NORMAL,
                WCF::getUser()
            );

            // reset user storage
            UserStorageHandler::getInstance()->reset([WCF::getUser()->userID], 'wbbUnreadWatchedThreads');

            $returnValue = false;
        }

        return $returnValue;
    }
}
