<?php

namespace wbb\data\thread\form\option;

use wcf\data\custom\option\CustomOption;

/**
 * Represents a contact option.
 *
 * @author  Joshua Ruesweg
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Thread\Form\Option
 * @since   5.2
 *
 * @property-read   int     $formID         the assignment to the form
 * @property-read   string      $tmpHash        a unique hash for options w/o a formID
 * @property-read   int     $timeCreated        the timestamp when the option is created
 */
class ThreadFormOption extends CustomOption
{
    /**
     * @inheritDoc
     */
    public static function getDatabaseTableAlias()
    {
        return 'thread_form_option';
    }
}
