<?php

namespace wbb\system\worker;

use wbb\data\board\BoardEditor;
use wbb\data\board\BoardList;
use wbb\system\cache\builder\BoardDataCacheBuilder;
use wcf\system\WCF;
use wcf\system\worker\AbstractRebuildDataWorker;

/**
 * Worker implementation for updating boards.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Worker
 *
 * @method  BoardList   getObjectList()
 */
class BoardRebuildDataWorker extends AbstractRebuildDataWorker
{
    /**
     * @inheritDoc
     */
    protected $objectListClassName = BoardList::class;

    /**
     * @inheritDoc
     */
    protected $limit = 20;

    /**
     * @inheritDoc
     */
    protected function initObjectList()
    {
        parent::initObjectList();

        $this->objectList->sqlOrderBy = 'board.boardID';
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        parent::execute();

        WCF::getDB()->beginTransaction();
        foreach ($this->objectList as $board) {
            $editor = new BoardEditor($board);

            // last posts
            $editor->updateLastPost();

            // stats
            $editor->rebuildStats();
        }
        WCF::getDB()->commitTransaction();

        BoardDataCacheBuilder::getInstance()->reset();
    }
}
