<section class="section tabularBox">
	<h2 class="sectionTitle">{lang}wbb.post.ipAddress.post{/lang}</h2>
	
	<table class="table">
		<thead>
			<tr>
				<th class="columnText">{lang}wbb.post.ipAddress.title{/lang}</th>
				<th class="columnText">{lang}wbb.post.ipAddress.hostname{/lang}</th>
				<th class="columnDate">{lang}wcf.global.date{/lang}</th>
			</tr>
		</thead>
		
		<tbody>
			<tr>
				<td class="columnText">{$ipAddress[ipAddress]}</td>
				<td class="columnText">{$ipAddress[hostname]}</td>
				<td class="columnDate">{@$ipAddress[time]|time}</td>
			</tr>
			{if $registrationIpAddress|isset}
				<tr>
					<td class="columnText">{$registrationIpAddress[ipAddress]} ({lang}wcf.user.register{/lang})</td>
					<td class="columnText">{$registrationIpAddress[hostname]}</td>
					<td class="columnDate">{@$registrationIpAddress[time]|time}</td>
				</tr>
			{/if}
		</tbody>
	</table>
</section>

{hascontent}
	<section class="section tabularBox">
		<h2 class="sectionTitle">{lang}wbb.post.ipAddress.author{/lang}</h2>
		
		<table class="table">
			<thead>
			<tr>
				<th class="columnText">{lang}wbb.post.ipAddress.title{/lang}</th>
				<th class="columnText">{lang}wbb.post.ipAddress.hostname{/lang}</th>
				<th class="columnDate">{lang}wcf.global.date{/lang}</th>
			</tr>
			</thead>
			
			<tbody>
				{content}
					{foreach from=$authorIpAddresses item=authorIpAddress}
						<tr>
							<td class="columnText">{$authorIpAddress[ipAddress]}</td>
							<td class="columnText">{$authorIpAddress[hostname]}</td>
							<td class="columnDate">{@$authorIpAddress[time]|time}</td>
						</tr>
					{/foreach}
				{/content}
			</tbody>
		</table>
	</section>
{/hascontent}

{hascontent}
	<section class="section tabularBox">
		<h2 class="sectionTitle">{lang}wbb.post.ipAddress.otherUsers{/lang}</h2>
		
		<table class="table">
			<thead>
				<tr>
					<th class="columnText">{lang}wcf.user.username{/lang}</th>
					<th class="columnDate">{lang}wcf.global.date{/lang}</th>
				</tr>
			</thead>
			
			<tbody>
				{content}
					{foreach from=$otherUsers item=user}
						<tr>
							<td class="columnText">
								{if $user[userID]}
									<a href="{link controller='User' id=$user[userID] title=$user[username]}{/link}" class="userLink" data-object-id="{@$user[userID]}">{$user[username]}</a>
								{else}
									{$user[username]} ({lang}wcf.user.guest{/lang})
								{/if}
							</td>
							<td class="columnDate">{@$user[time]|time}</td>
						</tr>
					{/foreach}
				{/content}
			</tbody>
		</table>
	</section>
{/hascontent}
