<?php

namespace wbb\system\tagging;

use wbb\data\thread\TaggedThreadList;
use wcf\system\tagging\AbstractCombinedTaggable;

/**
 * Implementation of ITaggable for thread tagging.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Tagging
 */
class TaggableThread extends AbstractCombinedTaggable
{
    /**
     * @inheritDoc
     */
    public function getObjectListFor(array $tags)
    {
        return new TaggedThreadList($tags);
    }

    /**
     * @inheritDoc
     */
    public function getTemplateName()
    {
        return 'searchResultThreadList';
    }
}
