{hascontent}
	{content}
		{foreach from=$labelGroups item=labelGroup}
			{if $labelGroup|count}
				<dl{if $errorType[$labelGroup->groupID]|isset} class="formError"{/if} style="display: none;">
					<dt><label>{$labelGroup->getTitle()}</label></dt>
					<dd>
						<ul class="labelList" data-object-id="{@$labelGroup->groupID}">
							<li class="dropdown labelChooser" id="labelGroup{@$labelGroup->groupID}" data-group-id="{@$labelGroup->groupID}" data-force-selection="{if $labelGroup->forceSelection}true{else}false{/if}">
								<div class="dropdownToggle" data-toggle="labelGroup{@$labelGroup->groupID}"><span class="badge label">{lang}wcf.label.none{/lang}</span></div>
								<div class="dropdownMenu">
									<ul class="scrollableDropdownMenu">
										{foreach from=$labelGroup item=label}
											<li data-label-id="{@$label->labelID}"><span>{@$label->render()}</span></li>
										{/foreach}
									</ul>
								</div>
							</li>
						</ul>
						{if $errorType[$labelGroup->groupID]|isset}
							<small class="innerError">{lang}wcf.label.error.{@$errorType[$labelGroup->groupID]}{/lang}</small>
						{/if}
					</dd>
				</dl>
			{/if}
		{/foreach}
	{/content}
	
	<script data-relocate="true" src="{@$__wcf->getPath()}js/WCF.Label.js"></script>
	<script data-relocate="true">
		$(function() {
			require(['EventHandler', 'Language', 'WoltLabSuite/Forum/Controller/Thread/LabelCondition'], function(EventHandler, Language, ControllerThreadLabelCondition) {
				Language.addObject({
					'wcf.label.none': '{jslang}wcf.label.none{/jslang}',
					'wcf.label.withoutSelection': '{jslang}wcf.label.withoutSelection{/jslang}'
				});
				
				new ControllerThreadLabelCondition('{$boardSelectorID}', { {implode from=$labelGroupMapping key=labelBoardID item=labelGroupIDs}{@$labelBoardID}: [ {implode from=$labelGroupIDs item=labelGroupID}{@$labelGroupID}{/implode} ]{/implode} });
				var labelChooser = new WCF.Label.Chooser({ {implode from=$labelIDs key=groupID item=labelID}{@$groupID}: {@$labelID}{/implode} }, '#formContainer', undefined, true);
				
				EventHandler.add('com.woltlab.wcf.boxControllerHandler', 'updateConditions', function() {
					labelChooser.destroy();
				});
			});
		});
	</script>
{/hascontent}
