<?php

/**
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 */

use wcf\system\box\BoxHandler;
use wcf\system\WCF;

$package = $this->installation->getPackage();

// hijack members list sort field
$sql = "UPDATE  wcf" . WCF_N . "_option
        SET     optionValue = ?
        WHERE   optionName = ?";
$statement = WCF::getDB()->prepareStatement($sql);
$statement->execute(['wbbPosts', 'members_list_default_sort_field']);

// create display mode condition for news box
BoxHandler::getInstance()->createBoxCondition(
    'com.woltlab.wbb.ThreadsAsNews',
    'com.woltlab.wbb.box.threadList.condition',
    'com.woltlab.wbb.displayMode',
    ['wbbThreadDisplayMode' => 'firstPostExcerpt']
);

// create unread condition for news box
BoxHandler::getInstance()->createBoxCondition(
    'com.woltlab.wbb.ThreadsAsNews',
    'com.woltlab.wbb.box.threadList.condition',
    'com.woltlab.wbb.isUnread.time',
    ['wbbThreadIsUnreadTime' => 1]
);

// create current board condition for most active threads box
BoxHandler::getInstance()->createBoxCondition(
    'com.woltlab.wbb.MostActiveThreads',
    'com.woltlab.wbb.box.threadList.condition',
    'com.woltlab.wbb.currentBoard',
    ['wbbThreadCurrentBoard' => 1]
);

// create current board condition for hot threads box
BoxHandler::getInstance()->createBoxCondition(
    'com.woltlab.wbb.HotThreads',
    'com.woltlab.wbb.box.threadList.condition',
    'com.woltlab.wbb.currentBoard',
    ['wbbThreadCurrentBoard' => 1]
);

// create unread condition for unread thread box
BoxHandler::getInstance()->createBoxCondition(
    'com.woltlab.wbb.UnreadThreads',
    'com.woltlab.wbb.box.threadList.condition',
    'com.woltlab.wbb.isUnread.lastPostTime',
    ['wbbThreadIsUnreadLastPostTime' => 1]
);

// assign box 'com.woltlab.wcf.UsersOnline' to BoardListPage, BoardPage and ThreadPage
BoxHandler::getInstance()->addBoxToPageAssignments(
    'com.woltlab.wcf.UsersOnline',
    ['com.woltlab.wbb.BoardList', 'com.woltlab.wbb.Board', 'com.woltlab.wbb.Thread']
);

// assign box 'com.woltlab.wcf.RegisterButton.content' to ThreadPage
BoxHandler::getInstance()->addBoxToPageAssignments(
    'com.woltlab.wcf.RegisterButton.content',
    ['com.woltlab.wbb.Thread']
);
