<?php

namespace wbb\data\board;

use wbb\system\cache\builder\BoardTagCloudCacheBuilder;
use wcf\system\tagging\TagCloud;

/**
 * Tag cloud implementation for boards.
 *
 * @author  Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Board
 */
class BoardTagCloud extends TagCloud
{
    /**
     * board id
     * @var int
     */
    public $boardID = 0;

    /**
     * Creates a new instance of BoardTagCloud.
     *
     * @param   int     $boardID
     * @param   int[]   $languageIDs
     */
    public function __construct($boardID, array $languageIDs = [])
    {
        $this->boardID = $boardID;

        parent::__construct($languageIDs);
    }

    /**
     * @inheritDoc
     */
    protected function loadCache()
    {
        $this->tags = BoardTagCloudCacheBuilder::getInstance()->getData([
            'boardID' => $this->boardID,
            'languageIDs' => $this->languageIDs,
        ]);
    }
}
