<?php

namespace wbb\data\board;

use wcf\system\WCF;

/**
 * Represents a board node list.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Board
 */
class SearchableBoardNodeList extends FilteredBoardNodeList
{
    /**
     * @inheritDoc
     */
    protected function isVisible(Board $board)
    {
        return $board->getPermission()
            && (!$board->isPrivate || WCF::getUser()->userID)
            && !$board->isIgnored()
            && $board->searchable
            && !$board->isExternalLink();
    }
}
