<?php

namespace wbb\data\thread\form;

use wbb\data\board\BoardAction;
use wbb\data\board\BoardEditor;
use wcf\data\AbstractDatabaseObjectAction;
use wcf\system\WCF;

/**
 * Executes thread form-related actions.
 *
 * @author  Joshua Ruesweg
 * @copyright   2001-2020 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Thread\Form
 * @since       5.3
 *
 * @method  ThreadFormEditor[]      getObjects()
 * @method  ThreadFormEditor        getSingleObject()
 */
class ThreadFormAction extends AbstractDatabaseObjectAction
{
    /**
     * @inheritDoc
     */
    protected $permissionsDelete = ['admin.board.canAddBoard'];

    /**
     * @inheritDoc
     */
    public function create()
    {
        /** @var ThreadForm $threadForm */
        $threadForm = parent::create();

        if (!empty($this->parameters['threadFormTmpHash'])) {
            $sql = "UPDATE  wbb" . WCF_N . "_thread_form_option
                    SET     formID = ?,
                            tmpHash = NULL
                    WHERE   tmpHash = ?";
            $statement = WCF::getDB()->prepareStatement($sql);
            $statement->execute([
                $threadForm->formID,
                $this->parameters['threadFormTmpHash'],
            ]);
        }

        if (!empty($this->parameters['boardIDs'])) {
            (new BoardAction($this->parameters['boardIDs'], 'update', [
                'data' => [
                    'formID' => $threadForm->formID,
                ],
            ]))->executeAction();
        }

        return $threadForm;
    }

    /**
     * @inheritDoc
     */
    public function update()
    {
        parent::update();

        if (isset($this->parameters['boardIDs']) && \count($this->objects) === 1) {
            try {
                WCF::getDB()->beginTransaction();
                $form = $this->getSingleObject();

                $sql = "UPDATE  wbb" . WCF_N . "_board 
                        SET     formID = NULL
                        WHERE   formID = ?";
                $statement = WCF::getDB()->prepareStatement($sql);
                $statement->execute([$form->formID]);

                if ($this->parameters['boardIDs'] !== []) {
                    (new BoardAction($this->parameters['boardIDs'], 'update', [
                        'data' => [
                            'formID' => $form->formID,
                        ],
                    ]))->executeAction();
                } else {
                    BoardEditor::resetCache();
                }
                WCF::getDB()->commitTransaction();
            } catch (\Exception $e) {
                WCF::getDB()->rollBackTransaction();

                throw $e;
            }
        }
    }
}
