/**
 * Shows a dialog overlay to setup ignored boards.
 *
 * @author  Joshua Ruesweg
 * @copyright  2001-2021 WoltLab GmbH
 * @license  WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Board/Ignore
 * @since 5.5
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Ui/Dialog", "WoltLabSuite/Core/Language", "WoltLabSuite/Core/Ui/Notification", "WoltLabSuite/Core/Dom/Util", "WoltLabSuite/Core/Ajax"], function (require, exports, tslib_1, Dialog_1, Language, UiNotification, Util_1, Ajax_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.setup = exports.Ignore = void 0;
    Dialog_1 = tslib_1.__importDefault(Dialog_1);
    Language = tslib_1.__importStar(Language);
    UiNotification = tslib_1.__importStar(UiNotification);
    Util_1 = tslib_1.__importDefault(Util_1);
    class Ignore {
        constructor(button) {
            button.addEventListener("click", (event) => {
                event.preventDefault();
                void this.loadDialog();
            });
        }
        async loadDialog() {
            const response = (await (0, Ajax_1.dboAction)("loadIgnoredBoards", "wbb\\data\\board\\BoardAction").dispatch());
            this.openDialog(response.template);
        }
        openDialog(template) {
            Dialog_1.default.open(this, template);
            const dialog = document.getElementById("wbbBoardIgnore");
            Array.from(dialog.querySelectorAll("input[type=checkbox]")).map((input) => {
                input.addEventListener("change", (target) => {
                    this.disableChildInputs(target.currentTarget);
                });
            });
        }
        disableChildInputs(checkbox) {
            const container = checkbox.closest("li");
            const child = container === null || container === void 0 ? void 0 : container.querySelectorAll("input[type=checkbox]");
            if (child) {
                Array.from(child).forEach((element) => {
                    if (element !== checkbox && !element.disabled) {
                        element.checked = checkbox.checked;
                    }
                });
            }
        }
        async saveBoardIDs(boardIDs) {
            const response = (await (0, Ajax_1.dboAction)("saveIgnoredBoards", "wbb\\data\\board\\BoardAction")
                .objectIds(boardIDs)
                .dispatch());
            this.savedBoardIDs(response.template);
        }
        savedBoardIDs(template) {
            UiNotification.show();
            Dialog_1.default.close(this);
            const dialog = Dialog_1.default.getDialog(this);
            if (dialog === undefined) {
                throw new Error("Dialog is undefined.");
            }
            const submitButton = dialog.submitButton;
            submitButton.disabled = false;
            const boardList = document.querySelector(".wbbBoardList");
            Util_1.default.setInnerHtml(boardList, template);
        }
        _dialogSetup() {
            return {
                id: "wbbBoardIgnore",
                options: {
                    title: Language.get("wbb.index.ignoreBoards"),
                },
                source: null,
            };
        }
        _dialogSubmit() {
            const dialog = Dialog_1.default.getDialog(this);
            if (dialog === undefined) {
                throw new Error("Dialog is undefined.");
            }
            const submitButton = dialog.submitButton;
            submitButton.disabled = true;
            const boardIDs = Array.from(dialog.content.querySelectorAll("input[type=checkbox]:checked")).map((checkbox) => parseInt(checkbox.value, 10));
            void this.saveBoardIDs(boardIDs);
        }
    }
    exports.Ignore = Ignore;
    function setup() {
        document.querySelectorAll(".ignoreBoardsButton").forEach((button) => {
            new Ignore(button);
        });
    }
    exports.setup = setup;
    exports.default = Ignore;
});
