{capture assign='headContent'}
	{if $__wcf->getUser()->userID}
		<link rel="alternate" type="application/rss+xml" title="{lang}wcf.global.button.rss{/lang}" href="{link application='wbb' controller='BoardFeed'}at={@$__wcf->getUser()->userID}-{@$__wcf->getUser()->accessToken}{/link}">
	{else}
		<link rel="alternate" type="application/rss+xml" title="{lang}wcf.global.button.rss{/lang}" href="{link application='wbb' controller='BoardFeed'}{/link}">
	{/if}
{/capture}

{capture assign='contentInteractionButtons'}
	<a href="#" class="markAllAsReadButton contentInteractionButton button small jsOnly"><span class="icon icon16 fa-check"></span> <span>{lang}wcf.global.button.markAllAsRead{/lang}</span></a>
{/capture}

{capture assign='contentInteractionDropdownItems'}
	<li><a rel="alternate" href="{if $__wcf->getUser()->userID}{link application='wbb' controller='BoardFeed'}at={@$__wcf->getUser()->userID}-{@$__wcf->getUser()->accessToken}{/link}{else}{link application='wbb' controller='BoardFeed'}{/link}{/if}" class="rssFeed">{lang}wcf.global.button.rss{/lang}</a></li>
	{if $__wcf->user->userID}
		<li class="jsOnly"><a href="#" class="ignoreBoardsButton">{lang}wbb.index.ignoreBoards{/lang}</a></li>
	{/if}
{/capture}

{capture assign='contentHeaderNavigation'}
	{if $__wcf->session->getPermission('user.board.canStartThread')}
		<li><a href="#" role="button" class="button buttonPrimary globalCreateThreadButton" title="{lang}wbb.thread.add{/lang}"><span class="icon icon16 fa-plus"></span> <span>{lang}wbb.thread.button.add{/lang}</span></a></li>
	{elseif !$__wcf->user->userID}
		<li><a href="{link controller='Login'}{/link}" class="button buttonPrimary" title="{lang}wbb.thread.add{/lang}"><span class="icon icon16 fa-plus"></span> <span>{lang}wbb.thread.button.add{/lang}</span></a></li>
	{/if}
{/capture}

{include file='header'}

{include file='boardNodeListContainer' application='wbb'}

{hascontent}
	<footer class="contentFooter">
		<nav class="contentFooterNavigation">
			<ul>
				{content}{event name='contentFooterNavigation'}{/content}
			</ul>
		</nav>
	</footer>
{/hascontent}

{capture assign='footerBoxes'}
	{if WBB_INDEX_ENABLE_STATS && $__wcf->session->getPermission('user.profile.canViewStatistics')}
		<section class="box">
			<h2 class="boxTitle">{lang}wbb.index.stats{/lang}</h2>

			<div class="boxContent">
				{lang}wbb.index.stats.detail{/lang}
			</div>
		</section>
	{/if}

	{event name='infoBoxes'}
{/capture}

<script data-relocate="true">
	require([
		'WoltLabSuite/Forum/Ui/Mobile',
		'WoltLabSuite/Forum/Ui/Board/MarkAllAsRead',
		'WoltLabSuite/Forum/Ui/Board/Ignore',
		'Language',
		'WoltLabSuite/Forum/Ui/Board/GlobalCreateThreadButton'
	], (
		WbbUiMobile,
		{ BoardMarkAllAsRead },
		IgnoreBoards,
		Language,
		GlobalCreateThreadButton
	) => {
		Language.addObject({
			'wbb.index.ignoreBoards': '{jslang}wbb.index.ignoreBoards{/jslang}',
			'wbb.index.selectForumForNewThread': '{jslang}wbb.index.selectForumForNewThread{/jslang}',
		});

		WbbUiMobile.init();

		new BoardMarkAllAsRead(document.querySelector(".markAllAsReadButton"));

		IgnoreBoards.setup();

		{if $__wcf->session->getPermission('user.board.canStartThread')}
			GlobalCreateThreadButton.setup();
		{/if}
	});
</script>

{include file='footer'}
