<?php

namespace wbb\system\message\embedded\object;

use wbb\data\post\ViewablePost;
use wbb\data\post\ViewablePostList;
use wcf\system\html\input\HtmlInputProcessor;
use wcf\system\message\embedded\object\AbstractMessageEmbeddedObjectHandler;
use wcf\system\WCF;

/**
 * Message embedded object handler implementation for posts.
 *
 * @author      Alexander Ebert
 * @copyright   2001-2019 WoltLab GmbH
 * @license     WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package     WoltLabSuite\Forum\System\Message\Embedded
 */
class PostMessageEmbeddedObjectHandler extends AbstractMessageEmbeddedObjectHandler
{
    /**
     * @inheritDoc
     */
    public function loadObjects(array $objectIDs)
    {
        if (!WCF::getSession()->getPermission('user.board.canViewBoard')) {
            return [];
        }

        return $this->getAccessibleObjects($objectIDs);
    }

    /**
     * @inheritDoc
     */
    public function parse(HtmlInputProcessor $htmlInputProcessor, array $embeddedData)
    {
        if (!WCF::getSession()->getPermission('user.board.canViewBoard')) {
            return [];
        }

        if (!empty($embeddedData['post'])) {
            $objectIDs = [];
            for ($i = 0, $length = \count($embeddedData['post']); $i < $length; $i++) {
                if (!empty($embeddedData['post'][$i][0])) {
                    $objectIDs[] = \intval($embeddedData['post'][$i][0]);
                }
            }

            if (!empty($objectIDs)) {
                return \array_keys($this->getAccessibleObjects($objectIDs));
            }
        }

        return [];
    }

    /**
     * @param int[] $objectIDs
     * @return ViewablePost[]
     */
    protected function getAccessibleObjects(array $objectIDs)
    {
        $objectList = new ViewablePostList();
        $objectList->enableAttachmentLoading(false);
        $objectList->enableEmbeddedObjectLoading(false);
        $objectList->enableModificationLogLoading(false);
        $objectList->enablePollLoading(false);
        $objectList->enableThreadLoading(true);
        $objectList->setObjectIDs($objectIDs);
        $objectList->readObjects();

        return \array_filter($objectList->getObjects(), static function (ViewablePost $post) {
            return $post->canRead();
        });
    }
}
