{include file='header' pageTitle='wbb.acp.board.permission.copy'}

<header class="contentHeader">
	<div class="contentHeaderTitle">
		<h1 class="contentTitle">{lang}wbb.acp.board.permission.copy{/lang}</h1>
	</div>
	
	<nav class="contentHeaderNavigation">
		<ul>
			<li><a href="{link application='wbb' controller='BoardList'}{/link}" class="button"><span class="icon icon16 fa-list"></span> <span>{lang}wbb.acp.menu.link.board.list{/lang}</span></a></li>
			
			{event name='contentHeaderNavigation'}
		</ul>
	</nav>
</header>

{include file='formError'}

{if $success|isset}
	<p class="success">{lang}wcf.global.success.edit{/lang}</p>
{/if}

<form method="post" action="{link application='wbb' controller='BoardPermissionCopy'}{/link}">
	<div class="section">
		<dl{if $errorField == 'boardID'} class="formError"{/if}>
			<dt>
				<label for="boardID">{lang}wbb.acp.board.permission.copy.boardID{/lang}</label>
			</dt>
			<dd>
				<select id="boardID" name="boardID">
					<option>{lang}wcf.global.noSelection{/lang}</option>
					{foreach from=$boardList item=boardNode}
						{if !$boardNode->getBoard()->isExternalLink}
							<option value="{@$boardNode->getBoard()->boardID}"{if $boardNode->getBoard()->boardID == $boardID} selected{/if}>{section name=i loop=$boardList->getDepth()}&nbsp;&nbsp;&nbsp;&nbsp;{/section}{$boardNode->getTitle()}</option>
						{/if}
					{/foreach}
				</select>
				{if $errorField == 'boardID'}
					<small class="innerError">
						{if $errorType == 'empty'}
							{lang}wcf.global.form.error.empty{/lang}
						{else}
							{lang}wbb.acp.board.permission.copy.boardID.error.{@$errorType}{/lang}
						{/if}
					</small>
				{/if}
			</dd>
		</dl>
		<dl{if $errorField == 'boardIDs'} class="formError"{/if}>
			<dt>
				<label for="boardIDs">{lang}wbb.acp.board.permission.copy.boardIDs{/lang}</label>
			</dt>
			<dd>
				<select id="boardIDs" name="boardIDs[]" multiple size="10">
					{foreach from=$boardList item=boardNode}
						{if !$boardNode->getBoard()->isExternalLink}
							<option value="{@$boardNode->getBoard()->boardID}"{if $boardNode->getBoard()->boardID|in_array:$boardIDs} selected{/if}>{section name=i loop=$boardList->getDepth()}&nbsp;&nbsp;&nbsp;&nbsp;{/section}{$boardNode->getTitle()}</option>
						{/if}
					{/foreach}
				</select>
				{if $errorField == 'boardIDs'}
					<small class="innerError">
						{if $errorType == 'empty'}
							{lang}wcf.global.form.error.empty{/lang}
						{else}
							{lang}wbb.acp.board.permission.copy.boardIDs.error.{@$errorType}{/lang}
						{/if}
					</small>
				{/if}
			</dd>
		</dl>
		<dl{if $errorField == 'copyAction'} class="formError"{/if}>
			<dt></dt>
			<dd>
				<label><input type="checkbox" name="copyPermissions" value="1"{if $copyPermissions} checked{/if}> {lang}wbb.acp.board.permission.copy.permissions{/lang}</label>
				{if $errorField == 'copyAction'}
					<small class="innerError">
						{lang}wbb.acp.board.permission.copy.copyAction.error.{@$errorType}{/lang}
					</small>
				{/if}
			</dd>
		</dl>
		<dl{if $errorField == 'copyAction'} class="formError"{/if}>
			<dt></dt>
			<dd>
				<label><input type="checkbox" name="copyModerators" value="1"{if $copyModerators} checked{/if}> {lang}wbb.acp.board.permission.copy.moderators{/lang}</label>
				{if $errorField == 'copyAction'}
					<small class="innerError">
						{lang}wbb.acp.board.permission.copy.copyAction.error.{@$errorType}{/lang}
					</small>
				{/if}
			</dd>
		</dl>
	</div>
	
	<div class="formSubmit">
		<input type="submit" value="{lang}wcf.global.button.submit{/lang}" accesskey="s">
		{csrfToken}
	</div>
</form>

<script data-relocate="true">
	(function() {
		var boardId = elById('boardID');
		var boardIds = elById('boardIDs');
		
		function updateBoardIds() {
			for (var i = 0; i < boardIds.options.length; i++) {
				var targetBoard = boardIds.options[i];
				
				if (targetBoard.value === boardId.value) {
					targetBoard.selected = false;
					targetBoard.disabled = true;
				}
				else {
					targetBoard.disabled = false;
				}
			}
		};
		
		boardId.addEventListener('change', updateBoardIds);
		
		updateBoardIds();
	})();
</script>

{include file='footer'}
