<p>{lang}wbb.post.edit.merge.description{/lang}</p>

<div id="postMergeContainer" class="section sortableListContainer">
	<ol class="sortableList simpleSortableList">
		{foreach from=$posts item=post}
			<li class="sortableNode">
				<article class="message messageReduced jsPostContainer" data-post-id="{@$post->postID}">
					<div class="messageContent">
						<header class="messageHeader">
							<div class="box32 messageHeaderWrapper">
								{if $post->getUserProfile()->userID}
									<span>{@$post->getUserProfile()->getAvatar()->getImageTag(32)}</span>
								{else}
									<span>{@$post->getUserProfile()->getAvatar()->getImageTag(32)}</span>
								{/if}
								
								<div class="messageHeaderBox">
									<h2 class="messageTitle">
										<span>{$post->getTitle()}</span>
									</h2>
									
									<ul class="messageHeaderMetaData">
										<li><span class="username">{$post->getUserProfile()->username}</span></li>
										<li><span class="messagePublicationTime">{@$post->time|time}</span></li>
										
										{event name='messageHeaderMetaData'}
									</ul>
								</div>
							</div>
						</header>
						
						<div class="messageBody">
							{event name='beforeMessageText'}
							
							<div class="messageText">
								{@$post->getExcerpt()}
							</div>
							
							{event name='afterMessageText'}
						</div>
					</div>
				</article>
			</li>
		{/foreach}
	</ol>
	
	<script data-relocate="true">
		$(function() {
			new WCF.Sortable.List('postMergeContainer', '', 0, {
				toleranceElement: '> article',
				items: 'li.sortableNode'
			}, true);
		});
	</script>
</div>

<div class="formSubmit">
	<button data-type="submit" class="buttonPrimary">{lang}wcf.global.button.submit{/lang}</button>
</div>