<?php

namespace wbb\data\post;

/**
 * Represents a list of search results.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\Data\Post
 *
 * @method  SearchResultPost    current()
 * @method  SearchResultPost[]  getObjects()
 * @method  SearchResultPost|null   getSingleObject()
 * @method  SearchResultPost|null   search($objectID)
 * @property    SearchResultPost[]  $objects
 */
class SearchResultPostList extends SimplifiedViewablePostList
{
    /**
     * @inheritDoc
     */
    public $decoratorClassName = SearchResultPost::class;

    /**
     * @inheritDoc
     */
    public function __construct()
    {
        parent::__construct();

        if (!empty($this->sqlSelects)) {
            $this->sqlSelects .= ',';
        }
        $this->sqlSelects .= 'thread.topic, board.boardID, board.title';
        $this->sqlJoins .= "
            LEFT JOIN   wbb" . WCF_N . "_thread thread
            ON          thread.threadID = post.threadID
            LEFT JOIN   wbb" . WCF_N . "_board board
            ON          board.boardID = thread.boardID";
    }
}
