<?php

namespace wbb\system\importer;

use wbb\system\thread\status\ThreadStatusHandler;
use wcf\system\importer\AbstractImporter;
use wcf\system\importer\ImportHandler;
use wcf\system\WCF;

/**
 * Imports watched threads.
 *
 * @author  Marcel Werk
 * @copyright   2001-2022 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Importer
 */
class WatchedThreadImporter extends AbstractImporter
{
    /**
     * @inheritDoc
     */
    public function import($oldID, array $data, array $additionalData = [])
    {
        $data['userID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wcf.user', $data['userID']);
        if (!$data['userID']) {
            return 0;
        }

        $data['objectID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wbb.thread', $data['objectID']);
        if (!$data['objectID']) {
            return 0;
        }

        $sql = "INSERT IGNORE INTO  wbb1_thread_user_status
                                    (userID, threadID, status)
                VALUES              (?, ?, ?)";
        $statement = WCF::getDB()->prepare($sql);
        $statement->execute([$data['userID'], $data['objectID'], $data['status'] ?? ThreadStatusHandler::SUBSCRIPTION_MODE_WATCHING]);
    }
}
