/**
 * IP Address handler for posts.
 *
 * @author  Joshua Ruesweg
 * @copyright 2001-2021 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module  WoltLabSuite/Forum/Ui/Post/IpAddressHandler
 * @since 5.5
 */
define(["require", "exports", "tslib", "WoltLabSuite/Core/Dom/Change/Listener", "WoltLabSuite/Core/Ui/Dialog", "WoltLabSuite/Core/Ajax", "WoltLabSuite/Core/Language"], function (require, exports, tslib_1, DomChangeListener, Dialog_1, Ajax, Language) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.IpAddressHandler = void 0;
    DomChangeListener = tslib_1.__importStar(DomChangeListener);
    Dialog_1 = tslib_1.__importDefault(Dialog_1);
    Ajax = tslib_1.__importStar(Ajax);
    Language = tslib_1.__importStar(Language);
    class IpAddressHandler {
        constructor() {
            this.buttons = new WeakSet();
            this.cache = new Map();
            this.rebuild();
            DomChangeListener.add("WoltLabSuite/Forum/Ui/Post/IpAddressHandler", () => this.rebuild());
        }
        rebuild() {
            document.querySelectorAll(".jsIpAddress[data-post-id]").forEach((button) => {
                const postId = ~~button.dataset.postId;
                if (!this.buttons.has(button)) {
                    button.addEventListener("click", (event) => this.click(event, postId));
                    this.buttons.add(button);
                }
            });
        }
        click(event, postId) {
            event === null || event === void 0 ? void 0 : event.preventDefault();
            if (this.cache.has(postId)) {
                Dialog_1.default.open(this, this.cache.get(postId));
            }
            else {
                Ajax.api(this, {
                    parameters: {
                        postID: postId,
                    },
                });
            }
        }
        _ajaxSuccess(data) {
            this.cache.set(data.returnValues.postID, data.returnValues.template);
            this.click(null, ~~data.returnValues.postID);
        }
        _ajaxSetup() {
            return {
                data: {
                    className: "wbb\\data\\post\\PostAction",
                    actionName: "getIpLog",
                },
            };
        }
        _dialogSetup() {
            return {
                id: "wbbIpAddressLog",
                source: null,
                options: {
                    title: Language.get("wbb.post.ipAddress.title"),
                },
            };
        }
    }
    exports.IpAddressHandler = IpAddressHandler;
    exports.default = IpAddressHandler;
});
