<?php

namespace wbb\system\condition\post;

use wbb\data\post\Post;
use wbb\data\post\PostList;
use wbb\system\condition\AbstractObjectBoardCondition;
use wcf\data\DatabaseObject;
use wcf\data\DatabaseObjectDecorator;
use wcf\data\DatabaseObjectList;
use wcf\system\exception\InvalidObjectArgument;

/**
 * Condition implementation for the board a post's thread belongs to.
 *
 * @author  Matthias Schmidt
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Condition\Post
 * @since   5.0
 */
class PostBoardCondition extends AbstractObjectBoardCondition
{
    /**
     * @inheritDoc
     */
    protected $fieldName = 'wbbPostBoard';

    /**
     * @inheritDoc
     */
    protected $label = 'wbb.post.condition.board';

    /**
     * @inheritDoc
     */
    public function addObjectListCondition(DatabaseObjectList $objectList, array $conditionData)
    {
        if (!($objectList instanceof PostList)) {
            throw new InvalidObjectArgument($objectList, PostList::class, 'Object list');
        }

        $objectList->sqlJoins .= "
            LEFT JOIN   wbb" . WCF_N . "_thread thread
            ON          thread.threadID = post.threadID";
        if (!empty($conditionData[$this->fieldName . '_reverseLogic'])) {
            $objectList->getConditionBuilder()->add('thread.boardID NOT IN (?)', [$conditionData[$this->fieldName]]);
        } else {
            $objectList->getConditionBuilder()->add('thread.boardID IN (?)', [$conditionData[$this->fieldName]]);
        }
    }

    /**
     * @inheritDoc
     */
    public function checkObject(DatabaseObject $object, array $conditionData)
    {
        if (
            !($object instanceof Post)
            && (!($object instanceof DatabaseObjectDecorator) || !($object->getDecoratedObject() instanceof Post))
        ) {
            throw new InvalidObjectArgument($object, Post::class);
        }

        $match = \in_array($object->getThread()->boardID, $conditionData[$this->fieldName]);

        if (!empty($conditionData[$this->fieldName . '_reverseLogic'])) {
            return !$match;
        }

        return $match;
    }
}
