<?php

namespace wbb\system\importer;

use wbb\data\post\Post;
use wbb\data\post\PostEditor;
use wcf\system\importer\AbstractImporter;
use wcf\system\importer\ImportHandler;
use wcf\system\WCF;

/**
 * Imports posts.
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package WoltLabSuite\Forum\System\Importer
 */
class PostImporter extends AbstractImporter
{
    /**
     * @inheritDoc
     */
    protected $className = Post::class;

    /**
     * @inheritDoc
     */
    public function import($oldID, array $data, array $additionalData = [])
    {
        $data['threadID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wbb.thread', $data['threadID']);
        if (!$data['threadID']) {
            return 0;
        }
        $data['userID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wcf.user', $data['userID']);
        if ($data['editorID']) {
            $data['editorID'] = ImportHandler::getInstance()->getNewID('com.woltlab.wcf.user', $data['editorID']);
        }

        // check old id
        if (\ctype_digit((string)$oldID)) {
            $sql = "SELECT  postID
                    FROM    wbb" . WCF_N . "_post
                    WHERE   postID = ?";
            $statement = WCF::getDB()->prepareStatement($sql);
            $statement->execute([$oldID]);
            if (!$statement->fetchSingleColumn()) {
                $data['postID'] = $oldID;
            }
        }

        $postID = PostEditor::fastCreate($data);

        ImportHandler::getInstance()->saveNewID('com.woltlab.wbb.post', $oldID, $postID);

        return $postID;
    }
}
